/*** 1.   ũƮ ***/

SELECT ROW_NUMBER() OVER (ORDER BY a.number) seq 
	, NEWID() main_code 
INTO TB_Main01
FROM master..spt_values a , (SELECT number 
                             FROM master..spt_values 
                             WHERE type = 'P' AND number < 10) b
WHERE a.type = 'P'
AND a.number BETWEEN 1 AND 1000

SELECT c.sub_code, ASCII(SUBSTRING(sub_code,1,1))*c.number value 
INTO TB_Sub01
FROM (SELECT b.number,CONVERT(NVARCHAR(36),main_code) sub_code
      FROM TB_Main01 a, (SELECT number 
                         FROM master..spt_values 
                         WHERE type = 'P' 
                         AND number BETWEEN 1 AND 40) b  
      WHERE a.seq%2 = 0
) c 
GO


/*** 2. [AS-IS] SQL    ȹ ***/

DECLARE @Main TABLE (seq INT,  main_code NVARCHAR(50) 
INDEX CIDX_Main CLUSTERED(seq,main_code) )

DECLARE @Sub TABLE (sub_code NVARCHAR(50), value INT 
INDEX CIDX_Sub CLUSTERED(sub_code,value) )

INSERT INTO @Main SELECT * FROM TB_Main01
INSERT INTO @Sub SELECT * FROM TB_Sub01

SELECT a.seq, a.main_code, MAX(b.value) max_value
FROM @Main a INNER JOIN @Sub b 
ON a.main_code = b.sub_code
GROUP BY a.seq, a.main_code
GO


/*** 6. [TO-BE]   ***/

CREATE TABLE #Main (seq INT, Main_Code nvarchar(50))
INSERT INTO #Main SELECT * FROM TB_Main01

CREATE TABLE #Sub (Sub_Code NVARCHAR(50), value INT)
INSERT INTO #Sub SELECT * FROM TB_Sub01

CREATE CLUSTERED INDEX CIDX_Main ON #Main(seq, main_code)
CREATE CLUSTERED INDEX CIDX_Sub ON #Sub(Sub_Code, value)

SELECT a.seq, a.main_code, MAX(b.value) max_value
FROM #Main a INNER JOIN #Sub b 
ON a.main_code = b.sub_code
GROUP BY a.seq, a.main_code
GO